/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ByteArrayDataInputStream;
import com.garmin.fit.DecoderBase;
import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.DeveloperFieldDescription;
import com.garmin.fit.DeveloperFieldDescriptionListener;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FieldDescriptionMesg;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.Profile;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;

public class Decoder
extends DecoderBase {
    private HashMap<Short, DeveloperDataIdMesg> developerDataIds = new HashMap();
    private HashMap<Short, HashMap<Short, FieldDescriptionMesg>> developerFields = new HashMap();

    public Decoder(byte[] byArray) {
        super(byArray);
    }

    public void read() throws Exception {
        while (this.stream.available() > 0) {
            this.resetCrc();
            this.decodeNextFile(this.stream);
        }
    }

    private void decodeNextFile(ByteArrayDataInputStream byteArrayDataInputStream) throws Exception {
        if (!Decoder.isFIT(byteArrayDataInputStream)) {
            throw new FitRuntimeException("The file is not a valid FIT file.");
        }
        int n = byteArrayDataInputStream.getPosition();
        byte[] byArray = this.readHeader();
        byte by = byArray[0];
        int n2 = ByteBuffer.wrap(byArray, 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        while (byteArrayDataInputStream.getPosition() < n + by + n2) {
            this.decodeRecord();
        }
        int n3 = byteArrayDataInputStream.readUShort();
        if ((long)n3 != this.getCrcValue()) {
            throw new FitRuntimeException("FIT decode error: File CRC failed.");
        }
    }

    private void decodeRecord() throws Exception {
        byte by = this.stream.peek();
        if ((by & 0x80) == 128) {
            this.decodeCompressedTimestampDataMessage();
            return;
        }
        if ((by & 0x40) == 0) {
            this.decodeMessage();
            return;
        }
        if ((by & 0x40) == 64) {
            this.decodeMessageDefinition();
            return;
        }
        throw new FitRuntimeException("Invalid record header: 0x" + Integer.toHexString(by));
    }

    private void decodeMessageDefinition() {
        int n;
        int n2 = this.readByte();
        int n3 = n2 & 0xF;
        this.localMesgDefs[n3] = new MesgDefinition();
        this.localMesgDefs[n3].localNum = n3;
        int n4 = this.readByte();
        this.localMesgDefs[n3].arch = this.readByte();
        this.localMesgDefs[n3].num = this.readUShort();
        if (this.localMesgDefs[n3].arch == 1) {
            this.localMesgDefs[n3].num = this.localMesgDefs[n3].num >> 8 | (this.localMesgDefs[n3].num & 0xFF) << 8;
        } else if (this.localMesgDefs[n3].arch != 0) {
            throw new FitRuntimeException("FIT decode error: Endian " + this.localMesgDefs[n3].arch + " not supported. Error at byte: " + this.stream.getPosition());
        }
        int n5 = this.readByte();
        for (n = 0; n < n5; ++n) {
            this.localMesgDefs[n3].fields.add(new FieldDefinition());
            this.localMesgDefs[n3].fields.get((int)n).num = this.readByte() & 0xFF;
            this.localMesgDefs[n3].fields.get((int)n).size = this.readByte() & 0xFF;
            this.localMesgDefs[n3].fields.get((int)n).type = this.readByte() & 0xFF;
        }
        if ((n2 & 0x20) == 32) {
            n = this.readByte();
            for (int i = 0; i < n; ++i) {
                DeveloperFieldDefinition developerFieldDefinition = new DeveloperFieldDefinition();
                developerFieldDefinition.setNum((short)(this.readByte() & 0xFF));
                developerFieldDefinition.setSize(this.readByte() & 0xFF);
                Short s = (short)(this.readByte() & 0xFF);
                developerFieldDefinition.setDeveloperDataIdMesg(this.developerDataIds.get(s));
                if (this.developerFields.get(s).containsKey(developerFieldDefinition.getNum())) {
                    FieldDescriptionMesg fieldDescriptionMesg = this.developerFields.get(s).get(developerFieldDefinition.getNum());
                    developerFieldDefinition.setFieldDescription(fieldDescriptionMesg);
                }
                this.localMesgDefs[n3].developerFields.add(developerFieldDefinition);
            }
        }
        for (MesgDefinitionListener mesgDefinitionListener : this.mesgDefListeners) {
            mesgDefinitionListener.onMesgDefinition(this.localMesgDefs[n3]);
        }
    }

    private void decodeMessage() {
        int n;
        int n2;
        int n3;
        int n4 = this.readByte();
        int n5 = n4 & 0xF;
        MesgDefinition mesgDefinition = this.localMesgDefs[n5];
        if (mesgDefinition == null) {
            throw new FitRuntimeException("Message Definition Not Found");
        }
        Mesg mesg = Factory.createMesg(this.localMesgDefs[n5].num);
        mesg.localNum = n5;
        mesg.setDecoderMessageIndex(this.decoderMesgIndex++);
        for (n3 = 0; n3 < mesgDefinition.fields.size(); ++n3) {
            int n6;
            FieldDefinition fieldDefinition = this.localMesgDefs[n5].fields.get(n3);
            Field field = Factory.createField(mesg.num, fieldDefinition.num);
            int n7 = Fit.baseTypeSizes[fieldDefinition.type & 0x1F];
            n2 = fieldDefinition.size / n7;
            n = this.readBytes(this.fieldData, 0, fieldDefinition.size);
            if (n != fieldDefinition.size) {
                throw new FitRuntimeException("End of file found while reading field data.");
            }
            if ((fieldDefinition.type & 0x80) != 0 && (this.localMesgDefs[n5].arch & 1) != 1) {
                this.flipFieldDataByteOrder(n7, n2);
            }
            if (field.getName().equals("unknown")) {
                field = new Field("unknown", fieldDefinition.num, fieldDefinition.type, 1.0, 0.0, "", false, Profile.Type.fromBaseType(fieldDefinition.type));
            }
            if (n7 != (n6 = Fit.baseTypeSizes[field.type & 0x1F])) continue;
            field.read(new ByteArrayInputStream(this.fieldData), n);
            if (field.getIsAccumulated()) {
                for (int i = 0; i < field.getNumValues(); ++i) {
                    long l = ((Number)field.getRawValue(i)).longValue();
                    for (Field field2 : mesg.fields) {
                        for (FieldComponent fieldComponent : field2.components) {
                            if (fieldComponent.fieldNum != field.num || !fieldComponent.accumulate) continue;
                            l = (long)(((double)l / field.scale - field.offset + fieldComponent.offset) * fieldComponent.scale);
                        }
                    }
                    this.accumulator.set(mesg.num, field.getNum(), l);
                }
            }
            if (field.getNumValues() <= 0) continue;
            mesg.addField(field);
        }
        for (n3 = 0; n3 < mesg.fields.size(); ++n3) {
            int n8 = mesg.getActiveSubFieldIndex(mesg.fields.get(n3).getNum());
            if (n8 == 65535) {
                if (mesg.fields.get((int)n3).components.size() <= 0) continue;
                this.expandComponents(mesg, mesg.fields.get(n3), mesg.fields.get((int)n3).components);
                continue;
            }
            if (mesg.fields.get((int)n3).subFields.get((int)n8).components.size() <= 0) continue;
            this.expandComponents(mesg, mesg.fields.get(n3), mesg.fields.get((int)n3).subFields.get((int)n8).components);
        }
        for (n3 = 0; n3 < mesgDefinition.developerFields.size(); ++n3) {
            DeveloperFieldDefinition developerFieldDefinition = mesgDefinition.developerFields.get(n3);
            int n9 = this.readBytes(this.fieldData, 0, developerFieldDefinition.getSize());
            if (n9 != developerFieldDefinition.getSize()) {
                throw new FitRuntimeException("End of file found while reading field data.");
            }
            DeveloperField developerField = new DeveloperField(developerFieldDefinition);
            if ((developerFieldDefinition.getType() & 0x1F) >= 17) continue;
            n2 = Fit.baseTypeSizes[developerFieldDefinition.getType() & 0x1F];
            n = developerFieldDefinition.getSize() / n2;
            if ((developerFieldDefinition.getType() & 0x80) != 0 && (mesgDefinition.arch & 1) != 1) {
                this.flipFieldDataByteOrder(n2, n);
            }
            developerField.read(new ByteArrayInputStream(this.fieldData), developerFieldDefinition.getSize());
            if (developerField.getNumValues() <= 0) continue;
            mesg.addDeveloperField(developerField);
        }
        switch (mesg.num) {
            case 207: {
                DeveloperDataIdMesg developerDataIdMesg = new DeveloperDataIdMesg(mesg);
                short s = developerDataIdMesg.getDeveloperDataIndex();
                this.developerDataIds.put(s, developerDataIdMesg);
                this.developerFields.put(s, new HashMap());
                break;
            }
            case 206: {
                FieldDescriptionMesg fieldDescriptionMesg = new FieldDescriptionMesg(mesg);
                short s = fieldDescriptionMesg.getDeveloperDataIndex();
                if (!this.developerFields.containsKey(s)) break;
                this.developerFields.get(s).put(fieldDescriptionMesg.getFieldDefinitionNumber(), fieldDescriptionMesg);
                DeveloperFieldDescription developerFieldDescription = new DeveloperFieldDescription(this.developerDataIds.get(s), fieldDescriptionMesg);
                for (DeveloperFieldDescriptionListener developerFieldDescriptionListener : this.devFieldDescListeners) {
                    developerFieldDescriptionListener.onDescription(developerFieldDescription);
                }
                break;
            }
        }
        for (MesgListener mesgListener : this.mesgListeners) {
            mesgListener.onMesg(mesg);
        }
    }
}

