/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Accumulator;
import com.garmin.fit.ByteArrayDataInputStream;
import com.garmin.fit.CRC16;
import com.garmin.fit.DeveloperFieldDescriptionListener;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.MesgSource;
import com.garmin.fit.SubField;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

abstract class DecoderBase
implements MesgSource {
    protected final int CompressedHeaderMask = 128;
    protected final int MesgDefinitionMask = 64;
    protected final int DevDataMask = 32;
    protected final int MesgHeaderMask = 0;
    protected final int LocalMesgNumMask = 15;
    protected final MesgDefinition[] localMesgDefs = new MesgDefinition[16];
    protected final byte[] fieldData = new byte[255];
    protected final ArrayList<MesgListener> mesgListeners = new ArrayList();
    protected final Accumulator accumulator = new Accumulator();
    protected ByteArrayDataInputStream stream = null;
    protected ArrayList<MesgDefinitionListener> mesgDefListeners = new ArrayList();
    protected ArrayList<DeveloperFieldDescriptionListener> devFieldDescListeners = new ArrayList();
    private CRC16 crc = null;
    protected int decoderMesgIndex = 0;

    protected DecoderBase() {
    }

    protected DecoderBase(byte[] byArray) {
        this.stream = new ByteArrayDataInputStream(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFIT(ByteArrayInputStream byteArrayInputStream) {
        try {
            byteArrayInputStream.mark(0);
            byte[] byArray = DecoderBase.readHeader(byteArrayInputStream);
            String string = new String(byArray, 8, 4);
            boolean bl = string.equals(".FIT");
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            byteArrayInputStream.reset();
        }
    }

    public static boolean isFIT(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return DecoderBase.isFIT(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkIntegrity(ByteArrayDataInputStream byteArrayDataInputStream) {
        try {
            while (byteArrayDataInputStream.available() > 0) {
                if (!DecoderBase.isFIT(byteArrayDataInputStream)) {
                    throw new Exception();
                }
                byteArrayDataInputStream.mark(0);
                byte[] byArray = DecoderBase.readHeader(byteArrayDataInputStream);
                byteArrayDataInputStream.reset();
                byte by = byArray[0];
                int n = ByteBuffer.wrap(byArray, 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                if (byteArrayDataInputStream.available() < by + n + 2) {
                    throw new Exception();
                }
                CRC16 cRC16 = new CRC16();
                byte[] byArray2 = new byte[by + n];
                byteArrayDataInputStream.read(byArray2, 0, by + n);
                cRC16.update(byArray2, 0, byArray2.length);
                int n2 = byteArrayDataInputStream.readUShort();
                if ((long)n2 == cRC16.getValue()) continue;
                throw new Exception();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            byteArrayDataInputStream.reset();
        }
    }

    public static boolean checkIntegrity(byte[] byArray) {
        ByteArrayDataInputStream byteArrayDataInputStream = new ByteArrayDataInputStream(byArray);
        return DecoderBase.checkIntegrity(byteArrayDataInputStream);
    }

    protected static byte[] readHeader(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = (byte)inputStream.read();
        byte by = byArray[0];
        if (by != 12 && by != 14) {
            throw new FitRuntimeException("Invalid Header Size");
        }
        int n = inputStream.read(byArray, 1, by - 1);
        if (n != by - 1) {
            throw new FitRuntimeException("Invalid Header - File Size less than Header Size");
        }
        return byArray;
    }

    protected byte[] readHeader() throws Exception {
        byte[] byArray = DecoderBase.readHeader(this.stream);
        byte by = byArray[0];
        this.crc.update(byArray, 0, by);
        return byArray;
    }

    public int readByte() {
        int n = this.stream.read();
        this.crc.update(n);
        return n;
    }

    public int readUShort() {
        int n = this.stream.readUShort();
        this.crc.update(n & 0xFF);
        this.crc.update(n >> 8 & 0xFF);
        return n;
    }

    public int readBytes(byte[] byArray, int n, int n2) {
        int n3 = this.stream.read(byArray, n, n2);
        this.crc.update(byArray, n, n2);
        return n3;
    }

    protected long getCrcValue() {
        return this.crc.getValue();
    }

    protected void resetCrc() {
        this.crc = new CRC16();
    }

    @Override
    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    public void addListener(MesgDefinitionListener mesgDefinitionListener) {
        if (mesgDefinitionListener != null && !this.mesgDefListeners.contains(mesgDefinitionListener)) {
            this.mesgDefListeners.add(mesgDefinitionListener);
        }
    }

    public void addListener(DeveloperFieldDescriptionListener developerFieldDescriptionListener) {
        if (developerFieldDescriptionListener != null && !this.devFieldDescListeners.contains(developerFieldDescriptionListener)) {
            this.devFieldDescListeners.add(developerFieldDescriptionListener);
        }
    }

    protected void expandComponents(Mesg mesg, Field field, ArrayList<FieldComponent> arrayList) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            FieldComponent fieldComponent = arrayList.get(i);
            if (fieldComponent.fieldNum != 255) {
                Double d;
                Field field2 = Factory.createField(mesg.num, fieldComponent.fieldNum);
                int n2 = mesg.getActiveSubFieldIndex(fieldComponent.fieldNum);
                SubField subField = field2.getSubField(n2);
                field2.setIsExpanded(true);
                Long l = field.getBitsValue(n, fieldComponent.bits, field2.isSignedInteger());
                if (l == null) break;
                if (fieldComponent.accumulate) {
                    l = this.accumulator.accumulate(mesg.num, fieldComponent.fieldNum, l, fieldComponent.bits);
                }
                if (field2.components.size() == 1) {
                    d = ((double)l.longValue() / fieldComponent.scale - fieldComponent.offset + field2.components.get((int)0).offset) * field2.components.get((int)0).scale;
                    if (mesg.hasField(field2.num)) {
                        mesg.getField(field2.num).addRawValue(d);
                    } else {
                        field2.addRawValue(d);
                        mesg.addField(field2);
                    }
                } else if (field2.components.size() > 1) {
                    for (int j = 0; j < fieldComponent.bits; j += Fit.baseTypeSizes[field2.type & 0x1F]) {
                        long l2 = (1L << Fit.baseTypeSizes[field2.type & 0x1F]) - 1L;
                        if (mesg.hasField(field2.num)) {
                            mesg.getField(field2.num).addValue(l & l2);
                        } else {
                            field2.addValue(l & l2);
                            mesg.addField(field2);
                        }
                        l = l >>> Fit.baseTypeSizes[field2.type & 0x1F];
                    }
                } else {
                    d = subField == null ? Double.valueOf(((double)l.longValue() / fieldComponent.scale - fieldComponent.offset + field2.offset) * field2.scale) : Double.valueOf(((double)l.longValue() / fieldComponent.scale - fieldComponent.offset + subField.offset) * subField.scale);
                    if (mesg.hasField(field2.num)) {
                        mesg.getField(field2.num).addRawValue(d);
                    } else {
                        field2.addRawValue(d);
                        mesg.addField(field2);
                    }
                }
            }
            n += fieldComponent.bits;
        }
    }

    protected void decodeCompressedTimestampDataMessage() throws Exception {
        int n = this.stream.read();
        throw new FitRuntimeException("Compressed timestamp messages are not currently supported.");
    }

    protected void flipFieldDataByteOrder(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n / 2; ++j) {
                byte by = this.fieldData[i * n + j];
                this.fieldData[i * n + j] = this.fieldData[i * n + n - j - 1];
                this.fieldData[i * n + n - j - 1] = by;
            }
        }
    }
}

