/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.Mesg;
import java.util.ArrayList;

public class SubField {
    protected String name;
    protected int type;
    protected double scale;
    protected double offset;
    protected String units;
    private ArrayList<SubFieldMap> maps;
    protected ArrayList<FieldComponent> components;

    protected SubField(SubField subField) {
        if (subField == null) {
            this.name = "unknown";
            this.type = 0;
            this.scale = 1.0;
            this.offset = 0.0;
            this.units = "";
            this.maps = new ArrayList();
            this.components = new ArrayList();
            return;
        }
        this.name = subField.name;
        this.type = subField.type;
        this.scale = subField.scale;
        this.offset = subField.offset;
        this.units = subField.units;
        this.maps = subField.maps;
        this.components = subField.components;
    }

    protected SubField(String string, int n, double d, double d2, String string2) {
        this.name = string;
        this.type = n;
        this.scale = d;
        this.offset = d2;
        this.units = string2;
        this.maps = new ArrayList();
        this.components = new ArrayList();
    }

    protected String getName() {
        return this.name;
    }

    protected int getType() {
        return this.type;
    }

    protected String getUnits() {
        return this.units;
    }

    protected void addMap(int n, long l) {
        this.maps.add(new SubFieldMap(n, l));
    }

    protected void addComponent(FieldComponent fieldComponent) {
        this.components.add(fieldComponent);
    }

    public boolean canMesgSupport(Mesg mesg) {
        for (SubFieldMap subFieldMap : this.maps) {
            if (!subFieldMap.canMesgSupport(mesg)) continue;
            return true;
        }
        return false;
    }

    private class SubFieldMap {
        private int refFieldNum;
        private long refFieldValue;

        protected SubFieldMap(int n, long l) {
            this.refFieldNum = n;
            this.refFieldValue = l;
        }

        protected boolean canMesgSupport(Mesg mesg) {
            Long l;
            Field field = mesg.getField(this.refFieldNum);
            return field != null && (l = field.getLongValue(0, 65535)) != null && l == this.refFieldValue;
        }
    }
}

