/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.ProtocolValidator;

class V1Validator
implements ProtocolValidator {
    V1Validator() {
    }

    private boolean hasDeveloperData(MesgDefinition mesgDefinition) {
        return mesgDefinition.developerFields.size() > 0;
    }

    @Override
    public boolean validateMesgDefn(MesgDefinition mesgDefinition) {
        if (this.hasDeveloperData(mesgDefinition)) {
            return false;
        }
        for (FieldDefinition fieldDefinition : mesgDefinition.getFields()) {
            int n = fieldDefinition.getType() & 0x1F;
            if (n <= 13) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validateMesg(Mesg mesg) {
        if (this.hasDeveloperData(new MesgDefinition(mesg))) {
            return false;
        }
        for (Field field : mesg.getFields()) {
            int n = field.getType() & 0x1F;
            if (n <= 13) continue;
            return false;
        }
        return true;
    }
}

