/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.Fit;
import com.garmin.fit.Profile;
import com.garmin.fit.csv.CSVWriter;
import com.garmin.fit.util.DateTimeConverter;
import com.garmin.fit.util.SemicirclesConverter;
import java.io.ByteArrayOutputStream;

public class MesgCSVWriterBase {
    protected CSVWriter csv;
    protected boolean bytesAsHex = false;
    protected boolean dateTimeAsISO8601 = false;
    protected boolean enumsAsStrings = false;
    protected boolean hideUnknownData = false;
    protected boolean showInvalidsAsEmpty = false;
    protected boolean removeExpandedFields = false;
    protected boolean preserveGaps = false;
    protected boolean semicirclesAsDegrees = false;

    public MesgCSVWriterBase(ByteArrayOutputStream byteArrayOutputStream) {
        this.csv = new CSVWriter(byteArrayOutputStream);
    }

    public void close() {
        this.csv.close();
    }

    public void enableHideUnknownData(boolean bl) {
        this.hideUnknownData = bl;
    }

    public boolean isHideUnknownDataEnabled() {
        return this.hideUnknownData;
    }

    public void enableBytesAsHex(boolean bl) {
        this.bytesAsHex = bl;
    }

    public boolean isBytesAsHexEnabled() {
        return this.bytesAsHex;
    }

    public void enableDateTimeAsISO8601(boolean bl) {
        this.dateTimeAsISO8601 = bl;
    }

    public boolean isDateTimeAsISO8601Enabled() {
        return this.dateTimeAsISO8601;
    }

    public void enableSemicirclesAsDegrees(boolean bl) {
        this.semicirclesAsDegrees = bl;
    }

    public boolean isSemicirclesAsDegreesEnabled() {
        return this.semicirclesAsDegrees;
    }

    public void enableShowInvalidsAsEmpty(boolean bl) {
        this.showInvalidsAsEmpty = bl;
    }

    public boolean isShowInvalidsAsEmptyEnabled() {
        return this.showInvalidsAsEmpty;
    }

    public void enableEnumsAsStrings(boolean bl) {
        this.enumsAsStrings = bl;
    }

    public boolean isEnumsAsStringsEnabled() {
        return this.enumsAsStrings;
    }

    public void enablePreserveGaps(boolean bl) {
        this.preserveGaps = bl;
    }

    public boolean isPreserveGapsEnabled() {
        return this.preserveGaps;
    }

    public void enableRemoveExpandedFields(boolean bl) {
        this.removeExpandedFields = bl;
    }

    public boolean isRemoveExpandedFieldsEnabled() {
        return this.removeExpandedFields;
    }

    protected String getValueString(FieldBase fieldBase, int n) {
        Profile.Type type;
        Object object = fieldBase.getValue(0, n);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Field field = (Field)fieldBase;
            type = field.getProfileType();
        }
        catch (ClassCastException classCastException) {
            type = Profile.Type.ENUM;
        }
        for (int i = 0; i < fieldBase.getNumValues(); ++i) {
            if (object == null || this.showInvalidsAsEmpty && object.equals(Fit.baseTypeInvalidMap.get(fieldBase.getType(n)))) continue;
            object = fieldBase.getValue(i, n);
            if (this.bytesAsHex && fieldBase.getType(n) == 13) {
                stringBuilder.append(String.format("0x%02x", object));
            } else if (this.semicirclesAsDegrees && fieldBase.getUnits().equals("semicircles")) {
                double d = SemicirclesConverter.semicirclesToDegrees(Integer.parseInt(object.toString()));
                stringBuilder.append(String.format("%.8f", d));
            } else if (this.dateTimeAsISO8601 && type.name().equalsIgnoreCase("DATE_TIME")) {
                stringBuilder.append(DateTimeConverter.fitTimestampToISO8601((Long)object));
            } else if (this.enumsAsStrings && type.ordinal() > Profile.Type.BOOL.ordinal()) {
                stringBuilder.append(Profile.enumValueName(type, ((Number)object).longValue()));
            } else {
                stringBuilder.append(object.toString());
            }
            if (i == fieldBase.getNumValues() - 1) continue;
            stringBuilder.append('|');
        }
        String string = stringBuilder.toString();
        string = string.replaceAll("\"", "\"\"");
        string = "\"" + string + "\"";
        return string;
    }

    protected String formatUnits(String string) {
        return this.formatUnits(string, null);
    }

    protected String formatUnits(String string, String string2) {
        if (this.semicirclesAsDegrees && string.equalsIgnoreCase("semicircles")) {
            return "degrees";
        }
        if (this.dateTimeAsISO8601 && string2 != null && string2.equalsIgnoreCase("DATE_TIME")) {
            return "";
        }
        return string;
    }
}

